//Jacek Matulewski, e-mail: jacek@fizyka.umk.pl

#ifndef UKLADYBRYLSZTYWNYCH_H
#define UKLADYBRYLSZTYWNYCH_H

#include "BrylaSztywna.h"

//#define _USE_MATH_DEFINES
//#include <math.h>

struct Prostopadloscian : public BrylaSztywna
{
	private:
		double a,b,c; //dlugosci krawedzi
		double gestosc;

	public:
		double Masa() const
		{
			double objetosc=a*b*c;
			return gestosc*objetosc;
		}

		Prostopadloscian(double a,double b,double c,double gestosc,Wektor polozenie,Wektor predkosc,Macierz macierzObrotu,Wektor predkoscKatowa,float kolor[4])
			:BrylaSztywna(polozenie,predkosc,macierzObrotu,predkoscKatowa,Macierz::Jednostkowa(),kolor)
			
		{
			this->a=a;
			this->b=b;
			this->c=c;
			this->gestosc=gestosc;
			srodekMasy->UstawMase(Masa());

			tensorMomentuBezwladnosci*=Masa()/12.0;
			tensorMomentuBezwladnosci[0]*=b*b+c*c; //Ixx
			tensorMomentuBezwladnosci[4]*=a*a+c*c; //Iyy
			tensorMomentuBezwladnosci[8]*=a*a+b*b; //Izz
		}

		Wektor Rozmiar()
		{
			return Wektor(a,b,c);
		}

		void PolozeniaWierzcholkowWzgledemSrodkaMasy(Wektor wierzcholki[8],bool nastepnePolozenia=false)
		{
			//wersja nieekonomiczna
			for(int iz=-1;iz<=1;iz+=2)
				for(int iy=-1;iy<=1;iy+=2)
					for(int ix=-1;ix<=1;ix+=2)
					{
						int i=2*(iz+1)+(iy+1)+(ix+1)/2;
						if(!nastepnePolozenia)
							wierzcholki[i]=MacierzObrotu().Transponowana()*Wektor(ix*a/2,iy*b/2,iz*c/2);
						else
							wierzcholki[i]=NastepnaMacierzObrotu().Transponowana()*Wektor(ix*a/2,iy*b/2,iz*c/2);
					}
		}

		/*
		void NastepnePolozeniaWierzcholkowWzgledemSrodkaMasy(Wektor wierzcholki[8])
		{
			//trzeba obliczyc trzy, a pozostale trzy ma przeciwne znaki
			for(int iz=-1;iz<=1;iz+=2)
				for(int iy=-1;iy<=1;iy+=2)
					for(int ix=-1;ix<=1;ix+=2)
					{
						int i=2*(iz+1)+(iy+1)+(ix+1)/2;						
						wierzcholki[i]=NastepnaMacierzObrotu().Transponowana()*Wektor(ix*a/2,iy*b/2,iz*c/2);
					}
		}
		*/

		void ProstopadloscianOgraniczajacyAABB(Wektor* min,Wektor* max,bool nastepny=false)
		{
			Wektor polozeniaWierzcholkow[8];
			PolozeniaWierzcholkowWzgledemSrodkaMasy(polozeniaWierzcholkow,nastepny);
			*min=Wektor::Zero();
			for(int i=0;i<8;++i)
			{
				if(polozeniaWierzcholkow[i].X<min->X) min->X=polozeniaWierzcholkow[i].X;
				if(polozeniaWierzcholkow[i].Y<min->Y) min->Y=polozeniaWierzcholkow[i].Y;
				if(polozeniaWierzcholkow[i].Z<min->Z) min->Z=polozeniaWierzcholkow[i].Z;
			}
			*max=-*min;
		}

		/*
		void NastepnyProstopadloscianOgraniczajacyAABB(Wektor* min,Wektor* max)
		{
			Wektor nastepnePolozeniaWierzcholkow[8];
			NastepnePolozeniaWierzcholkowWzgledemSrodkaMasy(nastepnePolozeniaWierzcholkow);
			*min=WektorZero;
			for(int i=0;i<8;++i)
			{
				if(nastepnePolozeniaWierzcholkow[i].X<min->X) min->X=nastepnePolozeniaWierzcholkow[i].X;
				if(nastepnePolozeniaWierzcholkow[i].Y<min->Y) min->Y=nastepnePolozeniaWierzcholkow[i].Y;
				if(nastepnePolozeniaWierzcholkow[i].Z<min->Z) min->Z=nastepnePolozeniaWierzcholkow[i].Z;
			}
			*max=-*min;
		}
		*/
};

class ZbiorProstopadloscianow : public ZbiorBrylSztywnych
{
	public:
		ZbiorProstopadloscianow(int ilosc,double a,double b,double c,double gestosc)
			:ZbiorBrylSztywnych(ilosc)
		{
			typedef BrylaSztywna* PBrylaSztywna;
			bryly=new PBrylaSztywna[ilosc];
			srand(0);
			for(int i=0;i<ilosc;++i)
			{
				float kolor[4]={0,1,0,1}; //zielony
				//bryly[i]=new Prostopadloscian(a,b,c,gestosc,Wektor(-1+2*i,0,0),WektorZero,Macierz(elementyMacierzyJednostkowej),Wektor(0,0.01*i,0.1),kolor);
				//bryly[i]=new Prostopadloscian(a,b,c,gestosc,Wektor(-1+2*i,0,0),Wektor(0,0,0),Macierz(elementyMacierzyJednostkowej),Wektor(0,0,0),kolor);
				//bryly[i]=new Prostopadloscian(a,b,c,gestosc,Wektor(-1+2*i,0,0),WektorZero,Macierz(elementyMacierzyJednostkowej),Wektor(0,0.01*i,0.1),kolor);
				//bryly[i]=new Prostopadloscian(a,b,c,gestosc,Wektor(-1+2.5*i,0,0),WektorZero,Macierz(elementyMacierzyJednostkowej),Wektor(0,0.01*i,0.1),kolor);
				//bryly[i]=new Prostopadloscian(a,b,c,gestosc,Wektor(-1+2.5*i,0,0),WektorZero,Macierz(elementyMacierzyJednostkowej),WektorZero,kolor);
				bryly[i]=new Prostopadloscian(a,b,c,gestosc,Wektor(-1+2.5*i,0,0),Wektor::Zero(),Macierz::Jednostkowa(),Wektor(0.2*rand()/(RAND_MAX+1.0),0.2*rand()/(RAND_MAX+1.0),0.2*rand()/(RAND_MAX+1.0)),kolor);
			}

			//bryly[0]->UstawPolozenieSrodkaMasy(Wektor(-1.5,0,0));			
			//bryly[0]->UstawPredkoscKatowa(Wektor(0,0.1,0.2));
			//bryly[0]->UstawPredkoscKatowa(Wektor(0.1,0,0));
			bryly[0]->UstawPredkoscKatowa(Wektor(0,0,0.1));
			bryly[0]->UstawPredkoscSrodkaMasy(Wektor(0.1,0,0));			

			//bryly[0]->UstawOrientacje(TworzMacierzObrotuZKataIOsiObrotu(0.75*M_PI/4,Wektor(0,0,1)));
			//bryly[0]->UstawPolozenieSrodkaMasy(Wektor(0.48,0,0));			
			//bryly[0]->UstawPredkoscKatowa(Wektor(0,0,0.1));
			//bryly[0]->UstawPredkoscSrodkaMasy(Wektor(0,0,0));			
		}

		~ZbiorProstopadloscianow()
		{
			for(int i=0;i<ilosc;++i) delete bryly[i];
			delete [] bryly;
			bryly=NULL;
		}

	protected:
		void ObliczSileIMomentSily(int indeks,Wektor& sila,Wektor& momentSily) const		
		{
			sila=Wektor::Zero();
			momentSily=Wektor::Zero();
			//if(indeks==0) momentSily=Wektor(0,0,0.01);
		}

};

class ZbiorProstopadloscianowZeZderzeniami : public ZbiorProstopadloscianow
{
	private:
		double* promienieSferOgraniczajacych;
		//int wynikiTestowNakrywaniaNaOsiach[16]; //-1=false, 1=true, 0=test jeszcze nie przeprowadzony
		//int poprzednieWynikiTestowNakrywaniaNaOsiach[16];

	public:
		ZbiorProstopadloscianowZeZderzeniami(int ilosc,double a,double b,double c,double gestosc)
			:ZbiorProstopadloscianow(ilosc,a,b,c,gestosc)
		{
			promienieSferOgraniczajacych=new double[ilosc];
			for(int i=0;i<ilosc;++i) promienieSferOgraniczajacych[i]=((Prostopadloscian*)bryly[i])->Rozmiar().Dlugosc()/2.0;

			/*
			for(int i=0;i<=15;++i) 
			{
				wynikiTestowNakrywaniaNaOsiach[i]=0;
				poprzednieWynikiTestowNakrywaniaNaOsiach[i]=0;
			}
			*/
		}

		virtual void PoPrzygotowaniuRuchu(double krokCzasowy)
		{			
			//detekcja BS
			/*
			for(int i=0;i<ilosc;++i)
			{
				Wektor polozenieSferyI=bryly[i]->NastepnePolozenieSrodkaMasy();
				for(int j=i+1;j<ilosc;++j)
				{
					Wektor polozenieSferyJ=bryly[j]->NastepnePolozenieSrodkaMasy();
					if((polozenieSferyJ-polozenieSferyI).Dlugosc()<(promienieSferOgraniczajacych[i]+promienieSferOgraniczajacych[j]))
					{	
						Beep(100,1);
					}
				}
			}
			*/

			//detekcja AABB
			/*
			for(int i=0;i<ilosc;++i)
			{
				Prostopadloscian* pI=(Prostopadloscian*)bryly[i];
				Wektor minI,maxI;
				pI->ProstopadloscianOgraniczajacyAABB(&minI,&maxI,true); //nastpny
				Wektor rozmiarI=maxI-minI;
				Wektor polozenieI=pI->NastepnePolozenieSrodkaMasy();
				for(int j=i+1;j<ilosc;++j)
				{
					Wektor minJ,maxJ;
					Prostopadloscian* pJ=(Prostopadloscian*)bryly[j];
					pJ->ProstopadloscianOgraniczajacyAABB(&minJ,&maxJ,true); //nastpny
					Wektor rozmiarJ=maxJ-minJ;
					Wektor polozenieJ=pJ->NastepnePolozenieSrodkaMasy();

					Wektor roznicaPolozen=polozenieJ-polozenieI;
					if( fabs((polozenieJ-polozenieI).X)<((rozmiarI.X+rozmiarJ.X)/2.0) &&
						fabs((polozenieJ-polozenieI).Y)<((rozmiarI.Y+rozmiarJ.Y)/2.0) &&
						fabs((polozenieJ-polozenieI).Z)<((rozmiarI.Z+rozmiarJ.Z)/2.0) )
					{
						Beep(100,1);
					}
				}
			}
			*/

			//detekcja OBB
			/*
			for(int i=0;i<ilosc;++i)
			{
				Prostopadloscian* pI=(Prostopadloscian*)bryly[i];
				for(int j=i+1;j<ilosc;++j)
				{
					Prostopadloscian* pJ=(Prostopadloscian*)bryly[j];
					//if(TestNakrywaniaDwochProstopadloscianow(pI,pJ))
					if(ZoptymalizowanyTestNakrywaniaDwochProstopadloscianow(pI,pJ,true))
					{
						Beep(100,1);
					}
				}
			}
			*/

			//detekcja BS+OBB
			for(int i=0;i<ilosc;++i)
			{
				Wektor polozenieSferyI=bryly[i]->NastepnePolozenieSrodkaMasy();
				for(int j=i+1;j<ilosc;++j)
				{
					Wektor polozenieSferyJ=bryly[j]->NastepnePolozenieSrodkaMasy();
					if((polozenieSferyJ-polozenieSferyI).Dlugosc()<(promienieSferOgraniczajacych[i]+promienieSferOgraniczajacych[j]))
					{
						//Beep(100,1);
						Prostopadloscian* pI=(Prostopadloscian*)bryly[i];
						Prostopadloscian* pJ=(Prostopadloscian*)bryly[j];
						if(ZoptymalizowanyTestNakrywaniaDwochProstopadloscianow(pI,pJ,true))						
						{
							Beep(100,1);
						}
					}
				}
			}


			//detekcja BS+OBB+reakcja na zderzenie
			/*
			for(int i=0;i<ilosc;++i)
			{
				Wektor polozenieSferyI=bryly[i]->NastepnePolozenieSrodkaMasy();
				for(int j=i+1;j<ilosc;++j)
				{
					Wektor polozenieSferyJ=bryly[j]->NastepnePolozenieSrodkaMasy();
					if((polozenieSferyJ-polozenieSferyI).Dlugosc()<(promienieSferOgraniczajacych[i]+promienieSferOgraniczajacych[j]))
					{	
						for(int indeksOsi=1;indeksOsi<=15;++indeksOsi) poprzednieWynikiTestowNakrywaniaNaOsiach[indeksOsi]=wynikiTestowNakrywaniaNaOsiach[indeksOsi];

						//kod wykonywany w razie wykrycia mozliwosci kolizji (test BS)
						//detekcja OBB
						Prostopadloscian* pI=(Prostopadloscian*)bryly[i];
						Prostopadloscian* pJ=(Prostopadloscian*)bryly[j];
						if(ZoptymalizowanyTestNakrywaniaDwochProstopadloscianow(pI,pJ,true))
						//if(TestNakrywaniaDwochProstopadloscianow(pI,pJ))
						{
							Beep(100,1);
							//wyznaczanie normalnej zderzenia
							//teraz na wszystkich osiach bedzie nakrywanie
							//normalna = os, ktora nie nakrywala sie poprzednim razem
							Wektor n(0,0,0); //normalna TO WSTAWIC DO ZOPTYMALIZOWANEFO TEST NAKRYWANIA!!!!!!!!!!!!!!!!
							for(int indeksOsi=1;indeksOsi<=15;++indeksOsi) 
								if(poprzednieWynikiTestowNakrywaniaNaOsiach[indeksOsi]==1)
								{
									n=OsRzutowania(indeksOsi,pI,pJ);
									n.Normuj();
								}


							//reakcja na zderzenie
							//!!!!!!!!!srodki mas tez - z inna normalna niz w ZPM
							double e=1;
							double Dvn=(pI->PredkoscSrodkaMasy()-pJ->PredkoscSrodkaMasy())*n;
							double masaZred=1/(1/pI->Masa()+1/pJ->Masa());
							double J=-masaZred*(e+1)*Dvn;			
							Wektor uI=pI->PredkoscSrodkaMasy()+n*J/pI->Masa();
							Wektor uJ=pJ->PredkoscSrodkaMasy()-n*J/pJ->Masa();
							pI->UstawPredkoscSrodkaMasy(uI);
							pJ->UstawPredkoscSrodkaMasy(uJ);
							
							Wektor wI=pI->PredkoscKatowa()+(pI->PolozenieSrodkaMasy()^(n*J));// *pI->odwroconyTensorMomentuBezwladnosci; //jaki tensor?????????
							Wektor wJ=pJ->PredkoscKatowa()+(pJ->PolozenieSrodkaMasy()^(-n*J));// *pJ->odwroconyTensorMomentuBezwladnosci;							
							pI->UstawPredkoscKatowa(wI);
							pJ->UstawPredkoscKatowa(wJ);

							Wektor wypadkowaSila,wypadkowyMomentSily;
							ObliczSileIMomentSily(i,wypadkowaSila,wypadkowyMomentSily);
							pI->PrzygotujRuch(wypadkowaSila,wypadkowyMomentSily,krokCzasowy,algorytmEulera);
							ObliczSileIMomentSily(j,wypadkowaSila,wypadkowyMomentSily);
							pJ->PrzygotujRuch(wypadkowaSila,wypadkowyMomentSily,krokCzasowy,algorytmEulera);
						}
						//*/
			/*
					}
				}
			}
			//*/
			
		}

		#pragma region Czytelna implementacja SAT (prostopadlosciany OBB)
		//Czytelna implementacja SAT (prostopadlosciany OBB)
		void ObliczRzutProstopadloscianuNaProsta(Prostopadloscian* p,Wektor n,double& min,double& max)
		{				
			Macierz macierzObrotu=p->MacierzObrotu();
			Wektor osX=macierzObrotu.KolumnaX();
			Wektor osY=macierzObrotu.KolumnaY();
			Wektor osZ=macierzObrotu.KolumnaZ();
			
			Wektor polowaRozmiaru=p->Rozmiar()/2;
			double polowaDlugosciRzutu=polowaRozmiaru.X*fabs(n*osX)+polowaRozmiaru.Y*fabs(n*osY)+polowaRozmiaru.Z*fabs(n*osZ);

			double rzutSrodkaMasy=n*p->PolozenieSrodkaMasy();
			min=rzutSrodkaMasy-polowaDlugosciRzutu;
			max=rzutSrodkaMasy+polowaDlugosciRzutu;
		}

		bool CzyOdcinkiNaProstejPokrywajaSie(double minA,double maxA,double minB,double maxB)
		{
			return !((maxA < minB) || (minA > maxB));
		}

		bool CzyRzutyProstopadloscianowNaOsNakladajaSie(Wektor n,Prostopadloscian* pA,Prostopadloscian* pB)
		{
			double minA,maxA,minB,maxB;
			ObliczRzutProstopadloscianuNaProsta(pA,n,minA,maxA);
			ObliczRzutProstopadloscianuNaProsta(pB,n,minB,maxB);
			return CzyOdcinkiNaProstejPokrywajaSie(minA,maxA,minB,maxB);
		}

		Wektor OsRzutowania(int indeks,Prostopadloscian* pA,Prostopadloscian* pB)
		{
			Macierz macierzObrotuA=pA->MacierzObrotu();
			Macierz macierzObrotuB=pB->MacierzObrotu();

			switch(indeks)
			{
				//A
				case 1: return macierzObrotuA.KolumnaX(); break;
				case 2: return macierzObrotuA.KolumnaY(); break;
				case 3: return macierzObrotuA.KolumnaZ(); break;
				//B
				case 4: return macierzObrotuB.KolumnaX(); break;
				case 5: return macierzObrotuB.KolumnaY(); break;
				case 6: return macierzObrotuB.KolumnaZ(); break;
				//iloczyny wektorowe AxB
				case 7: return macierzObrotuA.KolumnaX()^macierzObrotuB.KolumnaX(); break;
				case 8: return macierzObrotuA.KolumnaX()^macierzObrotuB.KolumnaY(); break;
				case 9: return macierzObrotuA.KolumnaX()^macierzObrotuB.KolumnaZ(); break;
				case 10: return macierzObrotuA.KolumnaY()^macierzObrotuB.KolumnaX(); break;
				case 11: return macierzObrotuA.KolumnaY()^macierzObrotuB.KolumnaY(); break;
				case 12: return macierzObrotuA.KolumnaY()^macierzObrotuB.KolumnaZ(); break;
				case 13: return macierzObrotuA.KolumnaZ()^macierzObrotuB.KolumnaX(); break;
				case 14: return macierzObrotuA.KolumnaY()^macierzObrotuB.KolumnaY(); break;
				case 15: return macierzObrotuA.KolumnaY()^macierzObrotuB.KolumnaZ(); break;
				default: return Wektor::Zero(); break;
			}
		}

		bool TestNakrywaniaDwochProstopadloscianow(Prostopadloscian* pA,Prostopadloscian* pB)
		{
			for(int i=1;i<=15;++i)
				if(!CzyRzutyProstopadloscianowNaOsNakladajaSie(OsRzutowania(i,pA,pB),pA,pB)) 
					return false;
			return true;
		}
		#pragma endregion

		bool ZoptymalizowanyTestNakrywaniaDwochProstopadloscianow(Prostopadloscian* pA,Prostopadloscian* pB,bool nastepnePolozenia)
		{
			//we wspolrzednych lokalnych prostopadloscianu A
			Macierz macierzObrotuA_Odwrotna,macierzObrotuB;
			Wektor pozycjaB;
			if(!nastepnePolozenia)
			{
				macierzObrotuA_Odwrotna=pA->MacierzObrotu().Transponowana();
				//macierz obrotow prostopadloscianu B we wspolrzednych lokalnych prostopadloscianu A
				macierzObrotuB = pB->MacierzObrotu()*macierzObrotuA_Odwrotna; 
				pozycjaB = macierzObrotuA_Odwrotna*(pB->PolozenieSrodkaMasy()-pA->PolozenieSrodkaMasy());			
			}
			else
			{
				macierzObrotuA_Odwrotna=pA->NastepnaMacierzObrotu().Transponowana();
				//macierz obrotow prostopadloscianu B we wspolrzednych lokalnych prostopadloscianu A
				macierzObrotuB = pB->NastepnaMacierzObrotu()*macierzObrotuA_Odwrotna; 				
				pozycjaB = macierzObrotuA_Odwrotna*(pB->NastepnePolozenieSrodkaMasy()-pA->NastepnePolozenieSrodkaMasy());			
			}

			Wektor osX=macierzObrotuB.KolumnaX();
			Wektor osY=macierzObrotuB.KolumnaY();
			Wektor osZ=macierzObrotuB.KolumnaZ();

			const double epsilon=1E-7;			
			Wektor absOsX=Wektor(fabs(osX.X)+epsilon,fabs(osX.Y)+epsilon,fabs(osX.Z)+epsilon);
			Wektor absOsY=Wektor(fabs(osY.X)+epsilon,fabs(osY.Y)+epsilon,fabs(osY.Z)+epsilon);
			Wektor absOsZ=Wektor(fabs(osZ.X)+epsilon,fabs(osZ.Y)+epsilon,fabs(osZ.Z)+epsilon);

			//polowy dlugosci krawedzi prostopadloscianu
			Wektor a=pA->Rozmiar()/2;
			Wektor b=pB->Rozmiar()/2;

			//15 testow
			//1 Ax
			if(fabs(pozycjaB.X) > a.X + b.X * absOsX.X + b.Y * absOsY.X + b.Z * absOsZ.X)
				return false;
			//2 Ay
			if(fabs(pozycjaB.Y) > a.Y + b.X * absOsX.Y + b.Y * absOsY.Y + b.Z * absOsZ.Y)
	            return false;
			//3 Az
			if(fabs(pozycjaB.Z) > a.Z + b.X * absOsX.Z + b.Y * absOsY.Z + b.Z * absOsZ.Z)
	            return false;
 
			//4 Bx
			if(fabs(pozycjaB.X*osX.X+pozycjaB.Y*osX.Y+pozycjaB.Z*osX.Z) >
	            (b.X+a.X*absOsX.X + a.Y * absOsX.Y + a.Z*absOsX.Z))
				return false;
			//5 By
			if(fabs(pozycjaB.X*osY.X+pozycjaB.Y*osY.Y+pozycjaB.Z*osY.Z) >
	            (b.Y+a.X*absOsY.X + a.Y * absOsY.Y + a.Z*absOsY.Z))
				return false;
			//6 Bz
			if(fabs(pozycjaB.X*osZ.X+pozycjaB.Y*osZ.Y+pozycjaB.Z*osZ.Z) >
	            (b.Z+a.X*absOsZ.X + a.Y * absOsZ.Y + a.Z*absOsZ.Z))
				return false;
 
	        //7 Ax x Bx
			if(fabs(pozycjaB.Z*osX.Y-pozycjaB.Y*osX.Z) > 
				a.Y*absOsX.Z + a.Z*absOsX.Y + b.Y*absOsZ.X + b.Z*absOsY.X)
				return false;
			//8 Ax x By
			if(fabs(pozycjaB.Z*osY.Y-pozycjaB.Y*osY.Z) > 
				a.Y*absOsY.Z + a.Z*absOsY.Y + b.X*absOsZ.X + b.Z*absOsX.X)
				return false;
			//9 Ax x Bz
			if(fabs(pozycjaB.Z*osZ.Y-pozycjaB.Y*osZ.Z) > 
				a.Y*absOsZ.Z + a.Z*absOsZ.Y + b.X*absOsY.X + b.Y*absOsX.X)
				return false;
	 
			//10 Ay x Bx
			if(fabs(pozycjaB.X*osX.Z-pozycjaB.Z*osX.X) > 
				a.X*absOsX.Z + a.Z*absOsX.X + b.Y*absOsZ.Y + b.Z*absOsY.Y)
				return false;
			//11 Ay x By
			if(fabs(pozycjaB.X*osY.Z-pozycjaB.Z*osY.X) > 
				a.X*absOsY.Z + a.Z*absOsY.X + b.X*absOsZ.Y + b.Z*absOsX.Y)
				return false;
			//12 Ay x Bz
			if(fabs(pozycjaB.X*osZ.Z-pozycjaB.Z*osZ.X) > a.X*absOsZ.Z + 
	            a.Z*absOsZ.X + b.X*absOsY.Y + b.Y*absOsX.Y)
				return false;
	 
			//13 Az x Bx
			if(fabs(pozycjaB.Y*osX.X-pozycjaB.X*osX.Y) > a.X*absOsX.Y + 
	            a.Y*absOsX.X + b.Y*absOsZ.Z + b.Z*absOsY.Z)
				return false;
			//14 Az x By
			if(fabs(pozycjaB.Y*osY.X-pozycjaB.X*osY.Y) > a.X*absOsY.Y + 
	            a.Y*absOsY.X + b.X*absOsZ.Z + b.Z*absOsX.Z)
				return false;
			//15 Az x Bz
			if(fabs(pozycjaB.Y*osZ.X-pozycjaB.X*osZ.Y) > a.X*absOsZ.Y + 
	            a.Y*absOsZ.X + b.X*absOsY.Z + b.Y*absOsX.Z)
				return false;
			
			return true;
		}
};

#endif
